function [r,a,Nd] = spherical_distribution_dipoles(R, N, pos0)

% This function obtains the position of the dipoles resulting from
% discretizing a in a cubic net a sphere in N punctual dipoles.

%%%%%% INPUT ARGUMENTS %%%%%%
%%% R:    radius of the sphere                                 %%%
%%% N:    number of dipoles inside the scatterer               %%%
%%% pos0: position of the center of mass of the parallelepiped %%%

%%%%%% OUTUT ARGUMENTS %%%%%%
%%% r: (Nd,3) vector containing the 3D positions of the Nd dipoles  %%%
%%% a:        lattice parametwr of the resulting net                %%%

a        = ((4/3)*pi/N)^(1/3)*R;  %%% Lattice constant

%%%% Generation of coordinates (solid cube of size 2R)%%%%
x  = -R:a:R;
y  = x;
z  = x;

[XXX,YYY,ZZZ] = meshgrid(x,y,z);
X(:) = XXX(1:numel(XXX));
Y(:) = YYY(1:numel(YYY));
Z(:) = ZZZ(1:numel(ZZZ));

%%% Discarding inner positions of the sphere %%%
k = 0;
for i = 1:length(X)
    if(X(i-k)^2+Y(i-k)^2+Z(i-k)^2 > R^2)
        X(i-k)  = [];
        Y(i-k)  = [];
        Z(i-k)  = [];
        k       = k+1;
    end
end

%%%% Displacing the center of mass %%%%
r(:,1) = X(:)+pos0(1);
r(:,2) = Y(:)+pos0(2);
r(:,3) = Z(:)+pos0(3);

%%%% Resulting number of dipoles %%%%
Nd = length(r(:,1));

end
